/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLanguageDetectionInput;
import com.azure.ai.textanalytics.implementation.models.LanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionTaskParameters;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

class DetectLanguageAsyncClient {
    private final ClientLogger logger = new ClientLogger(DetectLanguageAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceImpl service;

    DetectLanguageAsyncClient(TextAnalyticsClientImpl legacyService) {
        this.legacyService = legacyService;
        this.service = null;
    }

    DetectLanguageAsyncClient(MicrosoftCognitiveLanguageServiceImpl service) {
        this.legacyService = null;
        this.service = service;
    }

    Mono<Response<DetectLanguageResultCollection>> detectLanguageBatch(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getDetectedLanguageResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DetectLanguageResultCollection>> detectLanguageBatchWithContext(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getDetectedLanguageResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<DetectLanguageResultCollection>> getDetectedLanguageResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        TextAnalyticsRequestOptions textAnalyticsRequestOptions = options = options == null ? new TextAnalyticsRequestOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextLanguageDetectionInput().setParameters((LanguageDetectionTaskParameters)new LanguageDetectionTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new LanguageDetectionAnalysisInput().setDocuments(Utility.toLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Detected languages for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to detect language - {}", new Object[]{error})).map(Utility::toDetectLanguageResultCollectionResponse2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.languagesWithResponseAsync(new LanguageBatchInput().setDocuments(Utility.toLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Detected languages for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to detect language - {}", new Object[]{error})).map(Utility::toDetectLanguageResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }
}

