/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={TextAnalyticsClientImpl.class})
public final class TextAnalyticsClientImplBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final Map<String, String> properties = new HashMap<String, String>();
    private String apiVersion;
    private String endpoint;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;
    private HttpClient httpClient;
    private Configuration configuration;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();

    public TextAnalyticsClientImplBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public TextAnalyticsClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TextAnalyticsClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public TextAnalyticsClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public TextAnalyticsClientImplBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public TextAnalyticsClientImplBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TextAnalyticsClientImplBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public TextAnalyticsClientImplBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public TextAnalyticsClientImplBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public TextAnalyticsClientImpl buildClient() {
        if (this.apiVersion == null) {
            this.apiVersion = "v3.2-preview.2";
        }
        if (this.pipeline == null) {
            this.pipeline = this.createHttpPipeline();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        TextAnalyticsClientImpl client = new TextAnalyticsClientImpl(this.pipeline, this.serializerAdapter, this.apiVersion, this.endpoint);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policies.add(new CookiePolicy());
        policies.addAll(this.pipelinePolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return httpPipeline;
    }
}

