/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.models.HealthcareEntity;
import com.azure.ai.textanalytics.models.HealthcareEntityRelation;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.IterableStream;
import java.util.Map;

public final class AnalyzeHealthcareEntitiesResult
extends TextAnalyticsResult {
    private IterableStream<TextAnalyticsWarning> warnings;
    private IterableStream<HealthcareEntity> entities;
    private IterableStream<HealthcareEntityRelation> entityRelations;
    private Map<String, Object> fhirBundle;

    public AnalyzeHealthcareEntitiesResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        super(id, textDocumentStatistics, error);
    }

    public IterableStream<HealthcareEntity> getEntities() {
        this.throwExceptionIfError();
        return this.entities;
    }

    public IterableStream<TextAnalyticsWarning> getWarnings() {
        return this.warnings;
    }

    public IterableStream<HealthcareEntityRelation> getEntityRelations() {
        return this.entityRelations;
    }

    public Map<String, Object> getFhirBundle() {
        return this.fhirBundle;
    }

    private void setEntities(IterableStream<HealthcareEntity> entities) {
        this.entities = entities;
    }

    private void setWarnings(IterableStream<TextAnalyticsWarning> warnings) {
        this.warnings = warnings;
    }

    private void setEntityRelations(IterableStream<HealthcareEntityRelation> entityRelations) {
        this.entityRelations = entityRelations;
    }

    private void setFhirBundle(Map<String, Object> fhirBundle) {
        this.fhirBundle = fhirBundle;
    }

    static {
        AnalyzeHealthcareEntitiesResultPropertiesHelper.setAccessor(new AnalyzeHealthcareEntitiesResultPropertiesHelper.AnalyzeHealthcareEntitiesResultAccessor(){

            @Override
            public void setEntities(AnalyzeHealthcareEntitiesResult entitiesResult, IterableStream<HealthcareEntity> entities) {
                entitiesResult.setEntities((IterableStream<HealthcareEntity>)entities);
            }

            @Override
            public void setWarnings(AnalyzeHealthcareEntitiesResult entitiesResult, IterableStream<TextAnalyticsWarning> warnings) {
                entitiesResult.setWarnings((IterableStream<TextAnalyticsWarning>)warnings);
            }

            @Override
            public void setEntityRelations(AnalyzeHealthcareEntitiesResult entitiesResult, IterableStream<HealthcareEntityRelation> entityRelations) {
                entitiesResult.setEntityRelations((IterableStream<HealthcareEntityRelation>)entityRelations);
            }

            @Override
            public void setFhirBundle(AnalyzeHealthcareEntitiesResult entitiesResult, Map<String, Object> fhirBundle) {
                entitiesResult.setFhirBundle(fhirBundle);
            }
        });
    }
}

