// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The AnalyzeTextLROTask model. */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "kind",
        defaultImpl = AnalyzeTextLROTask.class)
@JsonTypeName("AnalyzeTextLROTask")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "CustomEntityRecognition", value = CustomEntitiesLROTask.class),
    @JsonSubTypes.Type(name = "CustomSingleLabelClassification", value = CustomSingleLabelClassificationLROTask.class),
    @JsonSubTypes.Type(name = "CustomMultiLabelClassification", value = CustomMultiLabelClassificationLROTask.class),
    @JsonSubTypes.Type(name = "Healthcare", value = HealthcareLROTask.class),
    @JsonSubTypes.Type(name = "SentimentAnalysis", value = SentimentAnalysisLROTask.class),
    @JsonSubTypes.Type(name = "EntityRecognition", value = EntitiesLROTask.class),
    @JsonSubTypes.Type(name = "EntityLinking", value = EntityLinkingLROTask.class),
    @JsonSubTypes.Type(name = "PiiEntityRecognition", value = PiiLROTask.class),
    @JsonSubTypes.Type(name = "KeyPhraseExtraction", value = KeyPhraseLROTask.class)
})
@Fluent
public class AnalyzeTextLROTask extends TaskIdentifier {
    /** {@inheritDoc} */
    @Override
    public AnalyzeTextLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
