// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The CustomEntitiesResult model. */
@Fluent
public final class CustomEntitiesResult extends CustomResult {
    /*
     * Response by document
     */
    @JsonProperty(value = "documents", required = true)
    private List<CustomEntitiesResultDocumentsItem> documents;

    /**
     * Get the documents property: Response by document.
     *
     * @return the documents value.
     */
    public List<CustomEntitiesResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: Response by document.
     *
     * @param documents the documents value to set.
     * @return the CustomEntitiesResult object itself.
     */
    public CustomEntitiesResult setDocuments(List<CustomEntitiesResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomEntitiesResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomEntitiesResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomEntitiesResult setProjectName(String projectName) {
        super.setProjectName(projectName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomEntitiesResult setDeploymentName(String deploymentName) {
        super.setDeploymentName(deploymentName);
        return this;
    }
}
