// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** The error object. */
@Fluent
public final class Error {
    /*
     * One of a server-defined set of error codes.
     */
    @JsonProperty(value = "code", required = true)
    private ErrorCode code;

    /*
     * A human-readable representation of the error.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /*
     * The target of the error.
     */
    @JsonProperty(value = "target")
    private String target;

    /*
     * An array of details about specific errors that led to this reported error.
     */
    @JsonProperty(value = "details")
    private List<Error> details;

    /*
     * An object containing more specific information than the current object about the error.
     */
    @JsonProperty(value = "innererror")
    private InnerErrorModel innererror;

    /*
     * The error object.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the code property: One of a server-defined set of error codes.
     *
     * @return the code value.
     */
    public ErrorCode getCode() {
        return this.code;
    }

    /**
     * Set the code property: One of a server-defined set of error codes.
     *
     * @param code the code value to set.
     * @return the Error object itself.
     */
    public Error setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: A human-readable representation of the error.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: A human-readable representation of the error.
     *
     * @param message the message value to set.
     * @return the Error object itself.
     */
    public Error setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: The target of the error.
     *
     * @return the target value.
     */
    public String getTarget() {
        return this.target;
    }

    /**
     * Set the target property: The target of the error.
     *
     * @param target the target value to set.
     * @return the Error object itself.
     */
    public Error setTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the details property: An array of details about specific errors that led to this reported error.
     *
     * @return the details value.
     */
    public List<Error> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: An array of details about specific errors that led to this reported error.
     *
     * @param details the details value to set.
     * @return the Error object itself.
     */
    public Error setDetails(List<Error> details) {
        this.details = details;
        return this;
    }

    /**
     * Get the innererror property: An object containing more specific information than the current object about the
     * error.
     *
     * @return the innererror value.
     */
    public InnerErrorModel getInnererror() {
        return this.innererror;
    }

    /**
     * Set the innererror property: An object containing more specific information than the current object about the
     * error.
     *
     * @param innererror the innererror value to set.
     * @return the Error object itself.
     */
    public Error setInnererror(InnerErrorModel innererror) {
        this.innererror = innererror;
        return this;
    }

    /**
     * Get the additionalProperties property: The error object.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: The error object.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the Error object itself.
     */
    public Error setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void setAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }
}
