// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ExtractedSummarySentence model. */
@Fluent
public final class ExtractedSummarySentence {
    /*
     * The extracted sentence text.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * A double value representing the relevance of the sentence within the summary. Higher values indicate higher
     * importance.
     */
    @JsonProperty(value = "rankScore", required = true)
    private double rankScore;

    /*
     * The sentence offset from the start of the document, based on the value of the parameter StringIndexType.
     */
    @JsonProperty(value = "offset", required = true)
    private int offset;

    /*
     * The length of the sentence.
     */
    @JsonProperty(value = "length", required = true)
    private int length;

    /**
     * Get the text property: The extracted sentence text.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The extracted sentence text.
     *
     * @param text the text value to set.
     * @return the ExtractedSummarySentence object itself.
     */
    public ExtractedSummarySentence setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the rankScore property: A double value representing the relevance of the sentence within the summary. Higher
     * values indicate higher importance.
     *
     * @return the rankScore value.
     */
    public double getRankScore() {
        return this.rankScore;
    }

    /**
     * Set the rankScore property: A double value representing the relevance of the sentence within the summary. Higher
     * values indicate higher importance.
     *
     * @param rankScore the rankScore value to set.
     * @return the ExtractedSummarySentence object itself.
     */
    public ExtractedSummarySentence setRankScore(double rankScore) {
        this.rankScore = rankScore;
        return this;
    }

    /**
     * Get the offset property: The sentence offset from the start of the document, based on the value of the parameter
     * StringIndexType.
     *
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: The sentence offset from the start of the document, based on the value of the parameter
     * StringIndexType.
     *
     * @param offset the offset value to set.
     * @return the ExtractedSummarySentence object itself.
     */
    public ExtractedSummarySentence setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: The length of the sentence.
     *
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: The length of the sentence.
     *
     * @param length the length value to set.
     * @return the ExtractedSummarySentence object itself.
     */
    public ExtractedSummarySentence setLength(int length) {
        this.length = length;
        return this;
    }
}
