// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** An object representing the task definition for an Extractive Summarization task. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("ExtractiveSummarization")
@Fluent
public final class ExtractiveSummarizationLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for an Extractive Summarization task.
     */
    @JsonProperty(value = "parameters")
    private ExtractiveSummarizationTaskParameters parameters;

    /**
     * Get the parameters property: Supported parameters for an Extractive Summarization task.
     *
     * @return the parameters value.
     */
    public ExtractiveSummarizationTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for an Extractive Summarization task.
     *
     * @param parameters the parameters value to set.
     * @return the ExtractiveSummarizationLROTask object itself.
     */
    public ExtractiveSummarizationLROTask setParameters(ExtractiveSummarizationTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractiveSummarizationLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
