// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The HealthcareEntitiesDocumentResult model. */
@Fluent
public class HealthcareEntitiesDocumentResult extends DocumentResult {
    /*
     * Healthcare entities.
     */
    @JsonProperty(value = "entities", required = true)
    private List<HealthcareEntity> entities;

    /*
     * Healthcare entity relations.
     */
    @JsonProperty(value = "relations", required = true)
    private List<HealthcareRelation> relations;

    /**
     * Get the entities property: Healthcare entities.
     *
     * @return the entities value.
     */
    public List<HealthcareEntity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: Healthcare entities.
     *
     * @param entities the entities value to set.
     * @return the HealthcareEntitiesDocumentResult object itself.
     */
    public HealthcareEntitiesDocumentResult setEntities(List<HealthcareEntity> entities) {
        this.entities = entities;
        return this;
    }

    /**
     * Get the relations property: Healthcare entity relations.
     *
     * @return the relations value.
     */
    public List<HealthcareRelation> getRelations() {
        return this.relations;
    }

    /**
     * Set the relations property: Healthcare entity relations.
     *
     * @param relations the relations value to set.
     * @return the HealthcareEntitiesDocumentResult object itself.
     */
    public HealthcareEntitiesDocumentResult setRelations(List<HealthcareRelation> relations) {
        this.relations = relations;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
