// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The HealthcareLinkingProperties model. */
@Fluent
public class HealthcareLinkingProperties {
    /*
     * The assertion property.
     */
    @JsonProperty(value = "assertion")
    private HealthcareAssertion assertion;

    /*
     * Preferred name for the entity. Example: 'histologically' would have a
     * 'name' of 'histologic'.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Entity references in known data sources.
     */
    @JsonProperty(value = "links")
    private List<HealthcareEntityLink> links;

    /**
     * Get the assertion property: The assertion property.
     *
     * @return the assertion value.
     */
    public HealthcareAssertion getAssertion() {
        return this.assertion;
    }

    /**
     * Set the assertion property: The assertion property.
     *
     * @param assertion the assertion value to set.
     * @return the HealthcareLinkingProperties object itself.
     */
    public HealthcareLinkingProperties setAssertion(HealthcareAssertion assertion) {
        this.assertion = assertion;
        return this;
    }

    /**
     * Get the name property: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     * 'histologic'.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     * 'histologic'.
     *
     * @param name the name value to set.
     * @return the HealthcareLinkingProperties object itself.
     */
    public HealthcareLinkingProperties setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the links property: Entity references in known data sources.
     *
     * @return the links value.
     */
    public List<HealthcareEntityLink> getLinks() {
        return this.links;
    }

    /**
     * Set the links property: Entity references in known data sources.
     *
     * @param links the links value to set.
     * @return the HealthcareLinkingProperties object itself.
     */
    public HealthcareLinkingProperties setLinks(List<HealthcareEntityLink> links) {
        this.links = links;
        return this;
    }
}
