// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles
 * within the relation context.
 */
@Fluent
public final class HealthcareRelation {
    /*
     * Type of relation. Examples include: `DosageOfMedication` or 'FrequencyOfMedication', etc.
     */
    @JsonProperty(value = "relationType", required = true)
    private RelationType relationType;

    /*
     * The entities in the relation.
     */
    @JsonProperty(value = "entities", required = true)
    private List<HealthcareRelationEntity> entities;

    /**
     * Get the relationType property: Type of relation. Examples include: `DosageOfMedication` or
     * 'FrequencyOfMedication', etc.
     *
     * @return the relationType value.
     */
    public RelationType getRelationType() {
        return this.relationType;
    }

    /**
     * Set the relationType property: Type of relation. Examples include: `DosageOfMedication` or
     * 'FrequencyOfMedication', etc.
     *
     * @param relationType the relationType value to set.
     * @return the HealthcareRelation object itself.
     */
    public HealthcareRelation setRelationType(RelationType relationType) {
        this.relationType = relationType;
        return this;
    }

    /**
     * Get the entities property: The entities in the relation.
     *
     * @return the entities value.
     */
    public List<HealthcareRelationEntity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: The entities in the relation.
     *
     * @param entities the entities value to set.
     * @return the HealthcareRelation object itself.
     */
    public HealthcareRelation setEntities(List<HealthcareRelationEntity> entities) {
        this.entities = entities;
        return this;
    }
}
