// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The set of tasks to execute on the input documents. Cannot specify the same task more than once. */
@Fluent
public final class JobManifestTasks {
    /*
     * The entityRecognitionTasks property.
     */
    @JsonProperty(value = "entityRecognitionTasks")
    private List<EntitiesTask> entityRecognitionTasks;

    /*
     * The entityRecognitionPiiTasks property.
     */
    @JsonProperty(value = "entityRecognitionPiiTasks")
    private List<PiiTask> entityRecognitionPiiTasks;

    /*
     * The keyPhraseExtractionTasks property.
     */
    @JsonProperty(value = "keyPhraseExtractionTasks")
    private List<KeyPhrasesTask> keyPhraseExtractionTasks;

    /*
     * The entityLinkingTasks property.
     */
    @JsonProperty(value = "entityLinkingTasks")
    private List<EntityLinkingTask> entityLinkingTasks;

    /*
     * The sentimentAnalysisTasks property.
     */
    @JsonProperty(value = "sentimentAnalysisTasks")
    private List<SentimentAnalysisTask> sentimentAnalysisTasks;

    /*
     * The extractiveSummarizationTasks property.
     */
    @JsonProperty(value = "extractiveSummarizationTasks")
    private List<ExtractiveSummarizationTask> extractiveSummarizationTasks;

    /*
     * The customEntityRecognitionTasks property.
     */
    @JsonProperty(value = "customEntityRecognitionTasks")
    private List<CustomEntitiesTask> customEntityRecognitionTasks;

    /*
     * The customSingleClassificationTasks property.
     */
    @JsonProperty(value = "customSingleClassificationTasks")
    private List<CustomSingleClassificationTask> customSingleClassificationTasks;

    /*
     * The customMultiClassificationTasks property.
     */
    @JsonProperty(value = "customMultiClassificationTasks")
    private List<CustomMultiClassificationTask> customMultiClassificationTasks;

    /**
     * Get the entityRecognitionTasks property: The entityRecognitionTasks property.
     *
     * @return the entityRecognitionTasks value.
     */
    public List<EntitiesTask> getEntityRecognitionTasks() {
        return this.entityRecognitionTasks;
    }

    /**
     * Set the entityRecognitionTasks property: The entityRecognitionTasks property.
     *
     * @param entityRecognitionTasks the entityRecognitionTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setEntityRecognitionTasks(List<EntitiesTask> entityRecognitionTasks) {
        this.entityRecognitionTasks = entityRecognitionTasks;
        return this;
    }

    /**
     * Get the entityRecognitionPiiTasks property: The entityRecognitionPiiTasks property.
     *
     * @return the entityRecognitionPiiTasks value.
     */
    public List<PiiTask> getEntityRecognitionPiiTasks() {
        return this.entityRecognitionPiiTasks;
    }

    /**
     * Set the entityRecognitionPiiTasks property: The entityRecognitionPiiTasks property.
     *
     * @param entityRecognitionPiiTasks the entityRecognitionPiiTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setEntityRecognitionPiiTasks(List<PiiTask> entityRecognitionPiiTasks) {
        this.entityRecognitionPiiTasks = entityRecognitionPiiTasks;
        return this;
    }

    /**
     * Get the keyPhraseExtractionTasks property: The keyPhraseExtractionTasks property.
     *
     * @return the keyPhraseExtractionTasks value.
     */
    public List<KeyPhrasesTask> getKeyPhraseExtractionTasks() {
        return this.keyPhraseExtractionTasks;
    }

    /**
     * Set the keyPhraseExtractionTasks property: The keyPhraseExtractionTasks property.
     *
     * @param keyPhraseExtractionTasks the keyPhraseExtractionTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setKeyPhraseExtractionTasks(List<KeyPhrasesTask> keyPhraseExtractionTasks) {
        this.keyPhraseExtractionTasks = keyPhraseExtractionTasks;
        return this;
    }

    /**
     * Get the entityLinkingTasks property: The entityLinkingTasks property.
     *
     * @return the entityLinkingTasks value.
     */
    public List<EntityLinkingTask> getEntityLinkingTasks() {
        return this.entityLinkingTasks;
    }

    /**
     * Set the entityLinkingTasks property: The entityLinkingTasks property.
     *
     * @param entityLinkingTasks the entityLinkingTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setEntityLinkingTasks(List<EntityLinkingTask> entityLinkingTasks) {
        this.entityLinkingTasks = entityLinkingTasks;
        return this;
    }

    /**
     * Get the sentimentAnalysisTasks property: The sentimentAnalysisTasks property.
     *
     * @return the sentimentAnalysisTasks value.
     */
    public List<SentimentAnalysisTask> getSentimentAnalysisTasks() {
        return this.sentimentAnalysisTasks;
    }

    /**
     * Set the sentimentAnalysisTasks property: The sentimentAnalysisTasks property.
     *
     * @param sentimentAnalysisTasks the sentimentAnalysisTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setSentimentAnalysisTasks(List<SentimentAnalysisTask> sentimentAnalysisTasks) {
        this.sentimentAnalysisTasks = sentimentAnalysisTasks;
        return this;
    }

    /**
     * Get the extractiveSummarizationTasks property: The extractiveSummarizationTasks property.
     *
     * @return the extractiveSummarizationTasks value.
     */
    public List<ExtractiveSummarizationTask> getExtractiveSummarizationTasks() {
        return this.extractiveSummarizationTasks;
    }

    /**
     * Set the extractiveSummarizationTasks property: The extractiveSummarizationTasks property.
     *
     * @param extractiveSummarizationTasks the extractiveSummarizationTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setExtractiveSummarizationTasks(
            List<ExtractiveSummarizationTask> extractiveSummarizationTasks) {
        this.extractiveSummarizationTasks = extractiveSummarizationTasks;
        return this;
    }

    /**
     * Get the customEntityRecognitionTasks property: The customEntityRecognitionTasks property.
     *
     * @return the customEntityRecognitionTasks value.
     */
    public List<CustomEntitiesTask> getCustomEntityRecognitionTasks() {
        return this.customEntityRecognitionTasks;
    }

    /**
     * Set the customEntityRecognitionTasks property: The customEntityRecognitionTasks property.
     *
     * @param customEntityRecognitionTasks the customEntityRecognitionTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setCustomEntityRecognitionTasks(List<CustomEntitiesTask> customEntityRecognitionTasks) {
        this.customEntityRecognitionTasks = customEntityRecognitionTasks;
        return this;
    }

    /**
     * Get the customSingleClassificationTasks property: The customSingleClassificationTasks property.
     *
     * @return the customSingleClassificationTasks value.
     */
    public List<CustomSingleClassificationTask> getCustomSingleClassificationTasks() {
        return this.customSingleClassificationTasks;
    }

    /**
     * Set the customSingleClassificationTasks property: The customSingleClassificationTasks property.
     *
     * @param customSingleClassificationTasks the customSingleClassificationTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setCustomSingleClassificationTasks(
            List<CustomSingleClassificationTask> customSingleClassificationTasks) {
        this.customSingleClassificationTasks = customSingleClassificationTasks;
        return this;
    }

    /**
     * Get the customMultiClassificationTasks property: The customMultiClassificationTasks property.
     *
     * @return the customMultiClassificationTasks value.
     */
    public List<CustomMultiClassificationTask> getCustomMultiClassificationTasks() {
        return this.customMultiClassificationTasks;
    }

    /**
     * Set the customMultiClassificationTasks property: The customMultiClassificationTasks property.
     *
     * @param customMultiClassificationTasks the customMultiClassificationTasks value to set.
     * @return the JobManifestTasks object itself.
     */
    public JobManifestTasks setCustomMultiClassificationTasks(
            List<CustomMultiClassificationTask> customMultiClassificationTasks) {
        this.customMultiClassificationTasks = customMultiClassificationTasks;
        return this;
    }
}
