// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The KeyPhrasesDocumentResult model. */
@Fluent
public class KeyPhrasesDocumentResult extends DocumentResult {
    /*
     * A list of representative words or phrases. The number of key phrases returned is proportional to the number of
     * words in the input document.
     */
    @JsonProperty(value = "keyPhrases", required = true)
    private List<String> keyPhrases;

    /**
     * Get the keyPhrases property: A list of representative words or phrases. The number of key phrases returned is
     * proportional to the number of words in the input document.
     *
     * @return the keyPhrases value.
     */
    public List<String> getKeyPhrases() {
        return this.keyPhrases;
    }

    /**
     * Set the keyPhrases property: A list of representative words or phrases. The number of key phrases returned is
     * proportional to the number of words in the input document.
     *
     * @param keyPhrases the keyPhrases value to set.
     * @return the KeyPhrasesDocumentResult object itself.
     */
    public KeyPhrasesDocumentResult setKeyPhrases(List<String> keyPhrases) {
        this.keyPhrases = keyPhrases;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhrasesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhrasesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhrasesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
