// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The LinkedEntitiesDocumentResult model. */
@Fluent
public class LinkedEntitiesDocumentResult extends DocumentResult {
    /*
     * Recognized well known entities in the document.
     */
    @JsonProperty(value = "entities", required = true)
    private List<LinkedEntity> entities;

    /**
     * Get the entities property: Recognized well known entities in the document.
     *
     * @return the entities value.
     */
    public List<LinkedEntity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: Recognized well known entities in the document.
     *
     * @param entities the entities value to set.
     * @return the LinkedEntitiesDocumentResult object itself.
     */
    public LinkedEntitiesDocumentResult setEntities(List<LinkedEntity> entities) {
        this.entities = entities;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LinkedEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LinkedEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LinkedEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
