// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains an input document to be analyzed by the service. */
@Fluent
public final class MultiLanguageInput {
    /*
     * A unique, non-empty document identifier.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The input text to process.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * (Optional) This is the 2 letter ISO 639-1 representation of a language. For example, use "en" for English; "es"
     * for Spanish etc. If not set, use "en" for English as default.
     */
    @JsonProperty(value = "language")
    private String language;

    /**
     * Get the id property: A unique, non-empty document identifier.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: A unique, non-empty document identifier.
     *
     * @param id the id value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the text property: The input text to process.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The input text to process.
     *
     * @param text the text value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the language property: (Optional) This is the 2 letter ISO 639-1 representation of a language. For example,
     * use "en" for English; "es" for Spanish etc. If not set, use "en" for English as default.
     *
     * @return the language value.
     */
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: (Optional) This is the 2 letter ISO 639-1 representation of a language. For example,
     * use "en" for English; "es" for Spanish etc. If not set, use "en" for English as default.
     *
     * @param language the language value to set.
     * @return the MultiLanguageInput object itself.
     */
    public MultiLanguageInput setLanguage(String language) {
        this.language = language;
        return this;
    }
}
