// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Supported parameters for a PII Entities Recognition task. */
@Fluent
public final class PiiTaskParameters extends PreBuiltTaskParameters {
    /*
     * The PII domain used for PII Entity Recognition.
     */
    @JsonProperty(value = "domain")
    private PiiDomain domain;

    /*
     * (Optional) describes the PII categories to return
     */
    @JsonProperty(value = "piiCategories")
    private List<PiiCategory> piiCategories;

    /*
     * Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes) according to
     * Unicode v8.0.0. For additional information see https://aka.ms/text-analytics-offsets.
     */
    @JsonProperty(value = "stringIndexType")
    private StringIndexType stringIndexType;

    /**
     * Get the domain property: The PII domain used for PII Entity Recognition.
     *
     * @return the domain value.
     */
    public PiiDomain getDomain() {
        return this.domain;
    }

    /**
     * Set the domain property: The PII domain used for PII Entity Recognition.
     *
     * @param domain the domain value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setDomain(PiiDomain domain) {
        this.domain = domain;
        return this;
    }

    /**
     * Get the piiCategories property: (Optional) describes the PII categories to return.
     *
     * @return the piiCategories value.
     */
    public List<PiiCategory> getPiiCategories() {
        return this.piiCategories;
    }

    /**
     * Set the piiCategories property: (Optional) describes the PII categories to return.
     *
     * @param piiCategories the piiCategories value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setPiiCategories(List<PiiCategory> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    /**
     * Get the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     *
     * @return the stringIndexType value.
     */
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Set the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     *
     * @param stringIndexType the stringIndexType value to set.
     * @return the PiiTaskParameters object itself.
     */
    public PiiTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }
}
