// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for RelationType. */
public final class RelationType extends ExpandableStringEnum<RelationType> {
    /** Static value Abbreviation for RelationType. */
    public static final RelationType ABBREVIATION = fromString("Abbreviation");

    /** Static value DirectionOfBodyStructure for RelationType. */
    public static final RelationType DIRECTION_OF_BODY_STRUCTURE = fromString("DirectionOfBodyStructure");

    /** Static value DirectionOfCondition for RelationType. */
    public static final RelationType DIRECTION_OF_CONDITION = fromString("DirectionOfCondition");

    /** Static value DirectionOfExamination for RelationType. */
    public static final RelationType DIRECTION_OF_EXAMINATION = fromString("DirectionOfExamination");

    /** Static value DirectionOfTreatment for RelationType. */
    public static final RelationType DIRECTION_OF_TREATMENT = fromString("DirectionOfTreatment");

    /** Static value DosageOfMedication for RelationType. */
    public static final RelationType DOSAGE_OF_MEDICATION = fromString("DosageOfMedication");

    /** Static value FormOfMedication for RelationType. */
    public static final RelationType FORM_OF_MEDICATION = fromString("FormOfMedication");

    /** Static value FrequencyOfMedication for RelationType. */
    public static final RelationType FREQUENCY_OF_MEDICATION = fromString("FrequencyOfMedication");

    /** Static value FrequencyOfTreatment for RelationType. */
    public static final RelationType FREQUENCY_OF_TREATMENT = fromString("FrequencyOfTreatment");

    /** Static value QualifierOfCondition for RelationType. */
    public static final RelationType QUALIFIER_OF_CONDITION = fromString("QualifierOfCondition");

    /** Static value RelationOfExamination for RelationType. */
    public static final RelationType RELATION_OF_EXAMINATION = fromString("RelationOfExamination");

    /** Static value RouteOfMedication for RelationType. */
    public static final RelationType ROUTE_OF_MEDICATION = fromString("RouteOfMedication");

    /** Static value TimeOfCondition for RelationType. */
    public static final RelationType TIME_OF_CONDITION = fromString("TimeOfCondition");

    /** Static value TimeOfEvent for RelationType. */
    public static final RelationType TIME_OF_EVENT = fromString("TimeOfEvent");

    /** Static value TimeOfExamination for RelationType. */
    public static final RelationType TIME_OF_EXAMINATION = fromString("TimeOfExamination");

    /** Static value TimeOfMedication for RelationType. */
    public static final RelationType TIME_OF_MEDICATION = fromString("TimeOfMedication");

    /** Static value TimeOfTreatment for RelationType. */
    public static final RelationType TIME_OF_TREATMENT = fromString("TimeOfTreatment");

    /** Static value UnitOfCondition for RelationType. */
    public static final RelationType UNIT_OF_CONDITION = fromString("UnitOfCondition");

    /** Static value UnitOfExamination for RelationType. */
    public static final RelationType UNIT_OF_EXAMINATION = fromString("UnitOfExamination");

    /** Static value ValueOfCondition for RelationType. */
    public static final RelationType VALUE_OF_CONDITION = fromString("ValueOfCondition");

    /** Static value ValueOfExamination for RelationType. */
    public static final RelationType VALUE_OF_EXAMINATION = fromString("ValueOfExamination");

    /**
     * Creates or finds a RelationType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RelationType.
     */
    @JsonCreator
    public static RelationType fromString(String name) {
        return fromString(name, RelationType.class);
    }

    /**
     * Gets known RelationType values.
     *
     * @return known RelationType values.
     */
    public static Collection<RelationType> values() {
        return values(RelationType.class);
    }
}
