// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SentenceOpinionSentiment. */
public final class SentenceOpinionSentiment extends ExpandableStringEnum<SentenceOpinionSentiment> {
    /** Static value positive for SentenceOpinionSentiment. */
    public static final SentenceOpinionSentiment POSITIVE = fromString("positive");

    /** Static value mixed for SentenceOpinionSentiment. */
    public static final SentenceOpinionSentiment MIXED = fromString("mixed");

    /** Static value negative for SentenceOpinionSentiment. */
    public static final SentenceOpinionSentiment NEGATIVE = fromString("negative");

    /**
     * Creates or finds a SentenceOpinionSentiment from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SentenceOpinionSentiment.
     */
    @JsonCreator
    public static SentenceOpinionSentiment fromString(String name) {
        return fromString(name, SentenceOpinionSentiment.class);
    }

    /** @return known SentenceOpinionSentiment values. */
    public static Collection<SentenceOpinionSentiment> values() {
        return values(SentenceOpinionSentiment.class);
    }
}
