// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Supported parameters for a Sentiment Analysis task. */
@Fluent
public final class SentimentAnalysisTaskParameters extends PreBuiltTaskParameters {
    /*
     * The opinionMining property.
     */
    @JsonProperty(value = "opinionMining")
    private Boolean opinionMining;

    /*
     * Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes) according to
     * Unicode v8.0.0. For additional information see https://aka.ms/text-analytics-offsets.
     */
    @JsonProperty(value = "stringIndexType")
    private StringIndexType stringIndexType;

    /**
     * Get the opinionMining property: The opinionMining property.
     *
     * @return the opinionMining value.
     */
    public Boolean isOpinionMining() {
        return this.opinionMining;
    }

    /**
     * Set the opinionMining property: The opinionMining property.
     *
     * @param opinionMining the opinionMining value to set.
     * @return the SentimentAnalysisTaskParameters object itself.
     */
    public SentimentAnalysisTaskParameters setOpinionMining(Boolean opinionMining) {
        this.opinionMining = opinionMining;
        return this;
    }

    /**
     * Get the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     *
     * @return the stringIndexType value.
     */
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Set the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     *
     * @param stringIndexType the stringIndexType value to set.
     * @return the SentimentAnalysisTaskParameters object itself.
     */
    public SentimentAnalysisTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentAnalysisTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentAnalysisTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }
}
