// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The SentimentDocumentResult model. */
@Fluent
public class SentimentDocumentResult extends DocumentResult {
    /*
     * Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     */
    @JsonProperty(value = "sentiment", required = true)
    private DocumentSentimentValue sentiment;

    /*
     * Document level sentiment confidence scores between 0 and 1 for each sentiment class.
     */
    @JsonProperty(value = "confidenceScores", required = true)
    private SentimentConfidenceScorePerLabel confidenceScores;

    /*
     * Sentence level sentiment analysis.
     */
    @JsonProperty(value = "sentences", required = true)
    private List<SentenceSentiment> sentences;

    /**
     * Get the sentiment property: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     *
     * @return the sentiment value.
     */
    public DocumentSentimentValue getSentiment() {
        return this.sentiment;
    }

    /**
     * Set the sentiment property: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     *
     * @param sentiment the sentiment value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setSentiment(DocumentSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    /**
     * Get the confidenceScores property: Document level sentiment confidence scores between 0 and 1 for each sentiment
     * class.
     *
     * @return the confidenceScores value.
     */
    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    /**
     * Set the confidenceScores property: Document level sentiment confidence scores between 0 and 1 for each sentiment
     * class.
     *
     * @param confidenceScores the confidenceScores value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    /**
     * Get the sentences property: Sentence level sentiment analysis.
     *
     * @return the sentences value.
     */
    public List<SentenceSentiment> getSentences() {
        return this.sentences;
    }

    /**
     * Set the sentences property: Sentence level sentiment analysis.
     *
     * @param sentences the sentences value to set.
     * @return the SentimentDocumentResult object itself.
     */
    public SentimentDocumentResult setSentences(List<SentenceSentiment> sentences) {
        this.sentences = sentences;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
