// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents the confidence scores across all sentiment classes: positive and negative. */
@Fluent
public final class TargetConfidenceScoreLabel {
    /*
     * Confidence score for positive sentiment
     */
    @JsonProperty(value = "positive", required = true)
    private double positive;

    /*
     * Confidence score for negative sentiment
     */
    @JsonProperty(value = "negative", required = true)
    private double negative;

    /**
     * Get the positive property: Confidence score for positive sentiment.
     *
     * @return the positive value.
     */
    public double getPositive() {
        return this.positive;
    }

    /**
     * Set the positive property: Confidence score for positive sentiment.
     *
     * @param positive the positive value to set.
     * @return the TargetConfidenceScoreLabel object itself.
     */
    public TargetConfidenceScoreLabel setPositive(double positive) {
        this.positive = positive;
        return this;
    }

    /**
     * Get the negative property: Confidence score for negative sentiment.
     *
     * @return the negative value.
     */
    public double getNegative() {
        return this.negative;
    }

    /**
     * Set the negative property: Confidence score for negative sentiment.
     *
     * @param negative the negative value to set.
     * @return the TargetConfidenceScoreLabel object itself.
     */
    public TargetConfidenceScoreLabel setNegative(double negative) {
        this.negative = negative;
        return this;
    }
}
