/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.CancelHealthJobHeaders;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.HealthHeaders;
import com.azure.ai.textanalytics.implementation.models.HealthcareJobState;
import com.azure.ai.textanalytics.implementation.models.HealthcareLROResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareLROTask;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class AnalyzeHealthcareEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(AnalyzeHealthcareEntityAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final AnalyzeTextsImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    AnalyzeHealthcareEntityAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    AnalyzeHealthcareEntityAsyncClient(AnalyzeTextsImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("beginAnalyzeHealthcareEntities", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
            this.throwIfCallingNotAvailableFeatureInOptions(options);
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeHealthcareEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
            String finalModelVersion = options.getModelVersion();
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            if (this.service != null) {
                String displayName = options.getDisplayName();
                return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new HealthcareLROTask().setParameters(new HealthcareTaskParameters().setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(healthResponse -> {
                    AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                    AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationDetail;
                })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationTextJob(operationId -> Mono.just((Object)((Object)this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
            }
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.legacyService.healthWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalStringIndexType, finalLoggingOptOut, finalContext).map(healthResponse -> {
                AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((HealthHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.legacyService.healthStatusWithResponseAsync((UUID)operationId, null, null, finalIncludeStatistics, finalContext)), this.cancelOperation(operationId -> this.legacyService.cancelHealthJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcarePagedIterable(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("beginAnalyzeHealthcareEntities", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
            this.throwIfCallingNotAvailableFeatureInOptions(options);
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeHealthcareEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
            String finalModelVersion = options.getModelVersion();
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            if (this.service != null) {
                String displayName = options.getDisplayName();
                return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new HealthcareLROTask().setParameters(new HealthcareTaskParameters().setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(healthResponse -> {
                    AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                    AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationDetail;
                })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeHealthcareEntitiesPagedIterable(this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
            }
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.legacyService.healthWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalStringIndexType, finalLoggingOptOut, finalContext).map(healthResponse -> {
                AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((HealthHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.legacyService.healthStatusWithResponseAsync((UUID)operationId, null, null, finalIncludeStatistics, finalContext)), this.cancelOperation(operationId -> this.legacyService.cancelHealthJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeHealthcareEntitiesPagedIterable(this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    AnalyzeHealthcareEntitiesPagedFlux getHealthcareEntitiesPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AnalyzeHealthcareEntitiesPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    Mono<PagedResponse<AnalyzeHealthcareEntitiesResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                Integer topValue = continuationTokenMap.getOrDefault("$top", null);
                Integer skipValue = continuationTokenMap.getOrDefault("$skip", null);
                Boolean showStatsValue = (Boolean)continuationTokenMap.getOrDefault(showStats, false);
                if (this.service != null) {
                    return this.service.jobStatusWithResponseAsync(operationId, showStatsValue, topValue, skipValue, context).map(this::toHealthcarePagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
                }
                return this.legacyService.healthStatusWithResponseAsync(operationId, topValue, skipValue, showStatsValue, context).map(this::toTextAnalyticsPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            if (this.service != null) {
                return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toHealthcarePagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            return this.legacyService.healthStatusWithResponseAsync(operationId, top, skip, showStats, context).map(this::toTextAnalyticsPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private PagedResponse<AnalyzeHealthcareEntitiesResultCollection> toTextAnalyticsPagedResponse(Response<HealthcareJobState> response) {
        List<Error> errors;
        HealthcareJobState healthcareJobState = (HealthcareJobState)response.getValue();
        HealthcareResult healthcareResult = healthcareJobState.getResults();
        AnalyzeHealthcareEntitiesResultCollection analyzeHealthcareEntitiesResultCollection = Utility.toAnalyzeHealthcareEntitiesResultCollection(healthcareResult);
        AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setModelVersion(analyzeHealthcareEntitiesResultCollection, healthcareResult.getModelVersion());
        RequestStatistics requestStatistics = healthcareResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setStatistics(analyzeHealthcareEntitiesResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = healthcareJobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Analyze healthcare operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw this.logger.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(analyzeHealthcareEntitiesResultCollection), healthcareJobState.getNextLink(), null);
    }

    private PagedResponse<AnalyzeHealthcareEntitiesResultCollection> toHealthcarePagedResponse(Response<AnalyzeTextJobState> response) {
        List<Error> errors;
        AnalyzeTextJobState jobState = (AnalyzeTextJobState)response.getValue();
        List<AnalyzeTextLROResult> lroResults = jobState.getTasks().getItems();
        HealthcareLROResult healthcareLROResult = (HealthcareLROResult)lroResults.get(0);
        HealthcareResult healthcareResult = healthcareLROResult.getResults();
        AnalyzeHealthcareEntitiesResultCollection analyzeHealthcareEntitiesResultCollection = Utility.toAnalyzeHealthcareEntitiesResultCollection(healthcareResult);
        AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setModelVersion(analyzeHealthcareEntitiesResultCollection, healthcareResult.getModelVersion());
        RequestStatistics requestStatistics = healthcareResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setStatistics(analyzeHealthcareEntitiesResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = jobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Analyze healthcare operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw this.logger.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(analyzeHealthcareEntitiesResultCollection), jobState.getNextLink(), null);
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesOperationDetail>> activationOperation(Mono<AnalyzeHealthcareEntitiesOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>>> pollingOperation(Function<UUID, Mono<Response<HealthcareJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(resultUuid)).flatMap(modelResponse -> this.processAnalyzeModelResponse((Response<HealthcareJobState>)modelResponse, (PollResponse<AnalyzeHealthcareEntitiesOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>>> pollingOperationTextJob(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<AnalyzeHealthcareEntitiesOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingOperation(Function<UUID, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingOperationTextJob(Function<UUID, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, PollResponse<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesOperationDetail>> cancelOperation(Function<UUID, Mono<ResponseBase<CancelHealthJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelHealthJobResponse -> {
                    AnalyzeHealthcareEntitiesOperationDetail operationResult = new AnalyzeHealthcareEntitiesOperationDetail();
                    AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((CancelHealthJobHeaders)cancelHealthJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, PollResponse<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesOperationDetail>> cancelOperationTextJob(Function<UUID, Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelHealthJobResponse -> {
                    AnalyzeHealthcareEntitiesOperationDetail operationResult = new AnalyzeHealthcareEntitiesOperationDetail();
                    AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelHealthJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesPagedIterable>> fetchingOperationIterable(Function<UUID, Mono<AnalyzeHealthcareEntitiesPagedIterable>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>> processAnalyzeModelResponse(Response<HealthcareJobState> analyzeOperationResultResponse, PollResponse<AnalyzeHealthcareEntitiesOperationDetail> operationResultPollResponse) {
        State state = ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((HealthcareJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setCreatedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getLastUpdateDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setExpiresAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue())));
    }

    private Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>> processAnalyzeTextModelResponse(Response<AnalyzeTextJobState> analyzeOperationResultResponse, PollResponse<AnalyzeHealthcareEntitiesOperationDetail> operationResultPollResponse) {
        State state = ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setDisplayName((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getDisplayName());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setCreatedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getLastUpdatedDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setExpiresAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue())));
    }

    private AnalyzeHealthcareEntitiesOptions getNotNullAnalyzeHealthcareEntitiesOptions(AnalyzeHealthcareEntitiesOptions options) {
        return options == null ? new AnalyzeHealthcareEntitiesOptions() : options;
    }

    private void throwIfCallingNotAvailableFeatureInOptions(AnalyzeHealthcareEntitiesOptions options) {
        if (options != null && options.getDisplayName() != null) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("AnalyzeHealthcareEntitiesOptions.displayName", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
        }
    }
}

