/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextEntityRecognitionInput;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

class RecognizeEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizeEntityAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    RecognizeEntityAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    RecognizeEntityAsyncClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<CategorizedEntityCollection> recognizeEntities(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.recognizeEntitiesBatch(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                CategorizedEntityCollection entityCollection = null;
                Iterator iterator = ((RecognizeEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizeEntitiesResult entitiesResult = (RecognizeEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    entityCollection = new CategorizedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
                }
                return entityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatch(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getRecognizedEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            return this.getRecognizedEntitiesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<RecognizeEntitiesResultCollection>> getRecognizedEntitiesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
        StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
        String finalModelVersion = options.getModelVersion();
        boolean finalLoggingOptOut = options.isServiceLogsDisabled();
        boolean finalIncludeStatistics = options.isIncludeStatistics();
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextEntityRecognitionInput().setParameters(new EntitiesTaskParameters().setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), finalIncludeStatistics, finalContext).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Recognized entities for a batch of documents- {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to recognize entities - {}", new Object[]{error})).map(Utility::toRecognizeEntitiesResultCollection2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.entitiesRecognitionGeneralWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalIncludeStatistics, finalLoggingOptOut, finalStringIndexType, finalContext).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Recognized entities for a batch of documents- {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to recognize entities - {}", new Object[]{error})).map(Utility::toRecognizeEntitiesResultCollection).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    private void throwIfCallingNotAvailableFeatureInOptions(TextAnalyticsRequestOptions options) {
        if (options != null && options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

