/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextSentimentAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import reactor.core.publisher.Mono;

class AnalyzeSentimentAsyncClient {
    private final ClientLogger logger = new ClientLogger(AnalyzeSentimentAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    AnalyzeSentimentAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    AnalyzeSentimentAsyncClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatch(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getAnalyzedSentimentResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithContext(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        try {
            return this.getAnalyzedSentimentResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<AnalyzeSentimentResultCollection>> getAnalyzedSentimentResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        AnalyzeSentimentOptions analyzeSentimentOptions = options = options == null ? new AnalyzeSentimentOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextSentimentAnalysisInput().setParameters(new SentimentAnalysisTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setOpinionMining(options.isIncludeOpinionMining()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Analyzed sentiment for a batch of documents - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to analyze sentiment - {}", new Object[]{error})).map(Utility::toAnalyzeSentimentResultCollectionResponse2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.sentimentWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), options.isIncludeOpinionMining(), StringIndexType.UTF16CODE_UNIT, Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Analyzed sentiment for a batch of documents - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to analyze sentiment - {}", new Object[]{error})).map(Utility::toAnalyzeSentimentResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    private void throwIfCallingNotAvailableFeatureInOptions(AnalyzeSentimentOptions options) {
        if (options == null) {
            return;
        }
        if (options.isIncludeOpinionMining()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("AnalyzeSentimentOptions.includeOpinionMining", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
        if (options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

