/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextKeyPhraseExtractionInput;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

class ExtractKeyPhraseAsyncClient {
    private final ClientLogger logger = new ClientLogger(ExtractKeyPhraseAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    ExtractKeyPhraseAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    ExtractKeyPhraseAsyncClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<KeyPhrasesCollection> extractKeyPhrasesSingleText(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.extractKeyPhrasesWithResponse(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                KeyPhrasesCollection keyPhrasesCollection = null;
                Iterator iterator = ((ExtractKeyPhrasesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    ExtractKeyPhraseResult keyPhraseResult = (ExtractKeyPhraseResult)iterator.next();
                    if (keyPhraseResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(keyPhraseResult.getError())));
                    }
                    keyPhrasesCollection = new KeyPhrasesCollection(keyPhraseResult.getKeyPhrases(), keyPhraseResult.getKeyPhrases().getWarnings());
                }
                return keyPhrasesCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getExtractedKeyPhrasesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            return this.getExtractedKeyPhrasesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<ExtractKeyPhrasesResultCollection>> getExtractedKeyPhrasesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        TextAnalyticsRequestOptions textAnalyticsRequestOptions = options = options == null ? new TextAnalyticsRequestOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextKeyPhraseExtractionInput().setParameters(new KeyPhraseTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("A batch of key phrases output - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to extract key phrases - {}", new Object[]{error})).map(Utility::toExtractKeyPhrasesResultCollectionResponse2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.keyPhrasesWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of document with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("A batch of key phrases output - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to extract key phrases - {}", new Object[]{error})).map(Utility::toExtractKeyPhrasesResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    private void throwIfCallingNotAvailableFeatureInOptions(TextAnalyticsRequestOptions options) {
        if (options != null && options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

