/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.RecognizeCustomEntitiesOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeCustomEntitiesResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesResult;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.CustomEntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class RecognizeCustomEntitiesAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizeCustomEntitiesAsyncClient.class);
    private final AnalyzeTextsImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    RecognizeCustomEntitiesAsyncClient(AnalyzeTextsImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    PollerFlux<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedFlux> recognizeCustomEntities(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, RecognizeCustomEntitiesOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginRecognizeCustomEntities", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullRecognizeCustomEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            String displayName = options.getDisplayName();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<RecognizeCustomEntitiesOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new CustomEntitiesLROTask().setParameters(new CustomEntitiesTaskParameters().setStringIndexType(finalStringIndexType).setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(responseBase -> {
                RecognizeCustomEntitiesOperationDetail operationDetail = new RecognizeCustomEntitiesOperationDetail();
                RecognizeCustomEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationTextJob(operationId -> Mono.just((Object)((Object)this.getRecognizeCustomEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> recognizeCustomEntitiesPagedIterable(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, RecognizeCustomEntitiesOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginRecognizeCustomEntities", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullRecognizeCustomEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            String displayName = options.getDisplayName();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<RecognizeCustomEntitiesOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new CustomEntitiesLROTask().setParameters(new CustomEntitiesTaskParameters().setStringIndexType(finalStringIndexType).setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(responseBase -> {
                RecognizeCustomEntitiesOperationDetail operationDetail = new RecognizeCustomEntitiesOperationDetail();
                RecognizeCustomEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new RecognizeCustomEntitiesPagedIterable(this.getRecognizeCustomEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    RecognizeCustomEntitiesPagedFlux getRecognizeCustomEntitiesPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new RecognizeCustomEntitiesPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    Mono<PagedResponse<RecognizeCustomEntitiesResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                Integer topValue = continuationTokenMap.getOrDefault("$top", null);
                Integer skipValue = continuationTokenMap.getOrDefault("$skip", null);
                Boolean showStatsValue = (Boolean)continuationTokenMap.getOrDefault(showStats, false);
                return this.service.jobStatusWithResponseAsync(operationId, showStatsValue, topValue, skipValue, context).map(this::toCustomEntitiesPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toCustomEntitiesPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private PagedResponse<RecognizeCustomEntitiesResultCollection> toCustomEntitiesPagedResponse(Response<AnalyzeTextJobState> response) {
        List<Error> errors;
        AnalyzeTextJobState jobState = (AnalyzeTextJobState)response.getValue();
        List<AnalyzeTextLROResult> lroResults = jobState.getTasks().getItems();
        CustomEntityRecognitionLROResult customEntityLROResult = (CustomEntityRecognitionLROResult)lroResults.get(0);
        CustomEntitiesResult customEntitiesResult = customEntityLROResult.getResults();
        RecognizeCustomEntitiesResultCollection recognizeCustomEntitiesResultCollection = Utility.toRecognizeCustomEntitiesResultCollection(customEntitiesResult);
        RequestStatistics requestStatistics = customEntitiesResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            RecognizeCustomEntitiesResultCollectionPropertiesHelper.setStatistics(recognizeCustomEntitiesResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = jobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Recognize custom entities operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw this.logger.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(recognizeCustomEntitiesResultCollection), jobState.getNextLink(), null);
    }

    private Function<PollingContext<RecognizeCustomEntitiesOperationDetail>, Mono<RecognizeCustomEntitiesOperationDetail>> activationOperation(Mono<RecognizeCustomEntitiesOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<RecognizeCustomEntitiesOperationDetail>, Mono<PollResponse<RecognizeCustomEntitiesOperationDetail>>> pollingOperationTextJob(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<RecognizeCustomEntitiesOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<RecognizeCustomEntitiesOperationDetail>, Mono<RecognizeCustomEntitiesPagedFlux>> fetchingOperationTextJob(Function<UUID, Mono<RecognizeCustomEntitiesPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((RecognizeCustomEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<RecognizeCustomEntitiesOperationDetail>, PollResponse<RecognizeCustomEntitiesOperationDetail>, Mono<RecognizeCustomEntitiesOperationDetail>> cancelOperationTextJob(Function<UUID, Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((RecognizeCustomEntitiesOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelJobResponse -> {
                    RecognizeCustomEntitiesOperationDetail operationResult = new RecognizeCustomEntitiesOperationDetail();
                    RecognizeCustomEntitiesOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<RecognizeCustomEntitiesOperationDetail>, Mono<RecognizeCustomEntitiesPagedIterable>> fetchingOperationIterable(Function<UUID, Mono<RecognizeCustomEntitiesPagedIterable>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((RecognizeCustomEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<RecognizeCustomEntitiesOperationDetail>> processAnalyzeTextModelResponse(Response<AnalyzeTextJobState> analyzeOperationResultResponse, PollResponse<RecognizeCustomEntitiesOperationDetail> operationResultPollResponse) {
        State state = ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        RecognizeCustomEntitiesOperationDetailPropertiesHelper.setDisplayName((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getDisplayName());
        RecognizeCustomEntitiesOperationDetailPropertiesHelper.setCreatedAt((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        RecognizeCustomEntitiesOperationDetailPropertiesHelper.setLastModifiedAt((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getLastUpdatedDateTime());
        RecognizeCustomEntitiesOperationDetailPropertiesHelper.setExpiresAt((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return Mono.just((Object)new PollResponse(status, (Object)((RecognizeCustomEntitiesOperationDetail)operationResultPollResponse.getValue())));
    }

    private RecognizeCustomEntitiesOptions getNotNullRecognizeCustomEntitiesOptions(RecognizeCustomEntitiesOptions options) {
        return options == null ? new RecognizeCustomEntitiesOptions() : options;
    }
}

