/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextPiiEntitiesRecognitionInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.PiiDomain;
import com.azure.ai.textanalytics.implementation.models.PiiTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesResult;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

class RecognizePiiEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizePiiEntityAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    RecognizePiiEntityAsyncClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    RecognizePiiEntityAsyncClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<PiiEntityCollection> recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("recognizePiiEntitiesBatch", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.recognizePiiEntitiesBatch(Collections.singletonList(new TextDocumentInput("0", document).setLanguage(language)), options).map(resultCollectionResponse -> {
                PiiEntityCollection entityCollection = null;
                Iterator iterator = ((RecognizePiiEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizePiiEntitiesResult entitiesResult = (RecognizePiiEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    entityCollection = new PiiEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getRedactedText(), entitiesResult.getEntities().getWarnings());
                }
                return entityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatch(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getRecognizePiiEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatchWithContext(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        try {
            return this.getRecognizePiiEntitiesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<RecognizePiiEntitiesResultCollection>> getRecognizePiiEntitiesResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        String finalDomainFilter;
        Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("recognizePiiEntitiesBatch", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        Utility.inputDocumentsValidation(documents);
        options = options == null ? new RecognizePiiEntitiesOptions() : options;
        Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
        StringIndexType finalStringIndexType = StringIndexType.UTF16CODE_UNIT;
        String finalModelVersion = options.getModelVersion();
        boolean finalLoggingOptOut = options.isServiceLogsDisabled();
        boolean finalIncludeStatistics = options.isIncludeStatistics();
        String string = finalDomainFilter = options.getDomainFilter() != null ? options.getDomainFilter().toString() : null;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextPiiEntitiesRecognitionInput().setParameters(new PiiTaskParameters().setDomain(PiiDomain.fromString(finalDomainFilter)).setPiiCategories(Utility.toCategoriesFilter(options.getCategoriesFilter())).setStringIndexType(finalStringIndexType).setModelVersion(finalModelVersion).setLoggingOptOut(finalLoggingOptOut)).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), finalIncludeStatistics, finalContext).doOnSubscribe(ignoredValue -> this.logger.info("Start recognizing Personally Identifiable Information entities for a batch of documents.")).doOnSuccess(response -> this.logger.info("Successfully recognized Personally Identifiable Information entities for a batch of documents.")).doOnError(error -> this.logger.warning("Failed to recognize Personally Identifiable Information entities - {}", new Object[]{error})).map(Utility::toRecognizePiiEntitiesResultCollectionResponse2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.entitiesRecognitionPiiWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), finalModelVersion, finalIncludeStatistics, finalLoggingOptOut, finalDomainFilter, finalStringIndexType, Utility.toCategoriesFilter(options.getCategoriesFilter()), finalContext).doOnSubscribe(ignoredValue -> this.logger.info("Start recognizing Personally Identifiable Information entities for a batch of documents.")).doOnSuccess(response -> this.logger.info("Successfully recognized Personally Identifiable Information entities for a batch of documents.")).doOnError(error -> this.logger.warning("Failed to recognize Personally Identifiable Information entities - {}", new Object[]{error})).map(Utility::toRecognizePiiEntitiesResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }
}

