/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClientBuilder;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.ClassifyDocumentOperationDetail;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.MultiLabelClassifyOptions;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.SingleLabelClassifyOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.ClassifyDocumentPagedIterable;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.util.Objects;

@ServiceClient(builder=TextAnalyticsClientBuilder.class)
public final class TextAnalyticsClient {
    private final TextAnalyticsAsyncClient client;

    TextAnalyticsClient(TextAnalyticsAsyncClient client) {
        this.client = client;
    }

    public String getDefaultCountryHint() {
        return this.client.getDefaultCountryHint();
    }

    public String getDefaultLanguage() {
        return this.client.getDefaultLanguage();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document) {
        return this.detectLanguage(document, this.client.getDefaultCountryHint());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document, String countryHint) {
        return (DetectedLanguage)this.client.detectLanguage(document, countryHint).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectLanguageResultCollection detectLanguageBatch(Iterable<String> documents, String countryHint, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (DetectLanguageResultCollection)((Object)this.client.detectLanguageBatch(documents, countryHint, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DetectLanguageResultCollection> detectLanguageBatchWithResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.detectLanguageAsyncClient.detectLanguageBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document) {
        return this.recognizeEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document, String language) {
        return (CategorizedEntityCollection)((Object)this.client.recognizeEntities(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeEntitiesResultCollection recognizeEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeEntitiesResultCollection)((Object)this.client.recognizeEntitiesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeEntitiesResultCollection> recognizeEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.recognizeEntityAsyncClient.recognizeEntitiesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document) {
        return this.recognizePiiEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document, String language) {
        return (PiiEntityCollection)((Object)this.client.recognizePiiEntities(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PiiEntityCollection recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        return (PiiEntityCollection)((Object)this.client.recognizePiiEntities(document, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizePiiEntitiesResultCollection recognizePiiEntitiesBatch(Iterable<String> documents, String language, RecognizePiiEntitiesOptions options) {
        return (RecognizePiiEntitiesResultCollection)((Object)this.client.recognizePiiEntitiesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizePiiEntitiesResultCollection> recognizePiiEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        return (Response)this.client.recognizePiiEntityAsyncClient.recognizePiiEntitiesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document) {
        return this.recognizeLinkedEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (LinkedEntityCollection)((Object)this.client.recognizeLinkedEntities(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeLinkedEntitiesResultCollection recognizeLinkedEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeLinkedEntitiesResultCollection)((Object)this.client.recognizeLinkedEntitiesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeLinkedEntitiesResultCollection> recognizeLinkedEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.recognizeLinkedEntityAsyncClient.recognizeLinkedEntitiesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document) {
        return this.extractKeyPhrases(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (KeyPhrasesCollection)((Object)this.client.extractKeyPhrases(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExtractKeyPhrasesResultCollection extractKeyPhrasesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (ExtractKeyPhrasesResultCollection)((Object)this.client.extractKeyPhrasesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExtractKeyPhrasesResultCollection> extractKeyPhrasesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.extractKeyPhraseAsyncClient.extractKeyPhrasesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document) {
        return this.analyzeSentiment(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document, String language) {
        return (DocumentSentiment)this.client.analyzeSentiment(document, language).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document, String language, AnalyzeSentimentOptions options) {
        return (DocumentSentiment)this.client.analyzeSentiment(document, language, options).block();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeSentimentResultCollection analyzeSentimentBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        return (AnalyzeSentimentResultCollection)((Object)this.client.analyzeSentimentBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeSentimentResultCollection analyzeSentimentBatch(Iterable<String> documents, String language, AnalyzeSentimentOptions options) {
        return (AnalyzeSentimentResultCollection)((Object)this.client.analyzeSentimentBatch(documents, language, options).block());
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeSentimentResultCollection> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        return (Response)this.client.analyzeSentimentAsyncClient.analyzeSentimentBatchWithContext(documents, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()), context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeSentimentResultCollection> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        return (Response)this.client.analyzeSentimentAsyncClient.analyzeSentimentBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<String> documents) {
        return this.beginAnalyzeHealthcareEntities(documents, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<String> documents, String language, AnalyzeHealthcareEntitiesOptions options) {
        return this.beginAnalyzeHealthcareEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        return this.client.analyzeHealthcareEntityAsyncClient.beginAnalyzeHealthcarePagedIterable(documents, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginRecognizeCustomEntities(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<String> documents, String projectName, String deploymentName, String language, RecognizeCustomEntitiesOptions options) {
        return this.beginRecognizeCustomEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<RecognizeCustomEntitiesOperationDetail, RecognizeCustomEntitiesPagedIterable> beginRecognizeCustomEntities(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, RecognizeCustomEntitiesOptions options, Context context) {
        return this.client.recognizeCustomEntitiesAsyncClient.recognizeCustomEntitiesPagedIterable(documents, projectName, deploymentName, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginSingleLabelClassify(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, SingleLabelClassifyOptions options) {
        return this.beginSingleLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginSingleLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, SingleLabelClassifyOptions options, Context context) {
        return this.client.labelClassifyAsyncClient.singleLabelClassifyPagedIterable(documents, projectName, deploymentName, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName) {
        return this.beginMultiLabelClassify(documents, projectName, deploymentName, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<String> documents, String projectName, String deploymentName, String language, MultiLabelClassifyOptions options) {
        return this.beginMultiLabelClassify(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), projectName, deploymentName, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> beginMultiLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, MultiLabelClassifyOptions options, Context context) {
        return this.client.labelClassifyAsyncClient.multiLabelClassifyPagedIterable(documents, projectName, deploymentName, options, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions) {
        return this.beginAnalyzeActions(documents, actions, this.client.getDefaultLanguage(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions, String language, AnalyzeActionsOptions options) {
        return this.client.analyzeActionsAsyncClient.beginAnalyzeActionsIterable(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), actions, options, Context.NONE).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        return this.client.analyzeActionsAsyncClient.beginAnalyzeActionsIterable(documents, actions, options, context).getSyncPoller();
    }
}

