/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AnalyzeTextsImpl {
    private final AnalyzeTextsService service;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl client;

    public AnalyzeTextsImpl(MicrosoftCognitiveLanguageServiceTextAnalysisImpl client) {
        this.service = (AnalyzeTextsService)RestProxy.create(AnalyzeTextsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeTextsSubmitJobHeaders, Void>> submitJobWithResponseAsync(AnalyzeTextJobsInput body, Context context) {
        String accept = "application/json";
        return this.service.submitJob(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeTextJobState>> jobStatusWithResponseAsync(UUID jobId, Boolean showStats, Integer top, Integer skip, Context context) {
        String accept = "application/json";
        return this.service.jobStatus(this.client.getEndpoint(), this.client.getApiVersion(), jobId, showStats, top, skip, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>> cancelJobWithResponseAsync(UUID jobId, Context context) {
        String accept = "application/json";
        return this.service.cancelJob(this.client.getEndpoint(), this.client.getApiVersion(), jobId, "application/json", context);
    }

    @Host(value="{Endpoint}/language")
    @ServiceInterface(name="MicrosoftCognitiveLa")
    public static interface AnalyzeTextsService {
        @Post(value="/analyze-text/jobs")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeTextsSubmitJobHeaders, Void>> submitJob(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AnalyzeTextJobsInput var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/analyze-text/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeTextJobState>> jobStatus(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") UUID var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="top") Integer var5, @QueryParam(value="skip") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/analyze-text/jobs/{jobId}:cancel")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>> cancelJob(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="jobId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

