/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.models.AnalyzeBatchInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeJobState;
import com.azure.ai.textanalytics.implementation.models.CancelHealthJobHeaders;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.HealthHeaders;
import com.azure.ai.textanalytics.implementation.models.HealthcareJobState;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.LanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.LanguageResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.PiiCategory;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class TextAnalyticsClientImpl {
    private final TextAnalyticsClientService service;
    private final String apiVersion;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    TextAnalyticsClientImpl(String apiVersion, String endpoint) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion, endpoint);
    }

    TextAnalyticsClientImpl(HttpPipeline httpPipeline, String apiVersion, String endpoint) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion, endpoint);
    }

    TextAnalyticsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.endpoint = endpoint;
        this.service = (TextAnalyticsClientService)RestProxy.create(TextAnalyticsClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeHeaders, Void>> analyzeWithResponseAsync(AnalyzeBatchInput body, Context context) {
        String accept = "application/json, text/json";
        return this.service.analyze(this.getEndpoint(), this.getApiVersion(), body, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeJobState>> analyzeStatusWithResponseAsync(String jobId, Boolean showStats, Integer top, Integer skip, Context context) {
        String accept = "application/json, text/json";
        return this.service.analyzeStatus(this.getEndpoint(), this.getApiVersion(), jobId, showStats, top, skip, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HealthcareJobState>> healthStatusWithResponseAsync(UUID jobId, Integer top, Integer skip, Boolean showStats, Context context) {
        String accept = "application/json, text/json";
        return this.service.healthStatus(this.getEndpoint(), this.getApiVersion(), jobId, top, skip, showStats, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CancelHealthJobHeaders, Void>> cancelHealthJobWithResponseAsync(UUID jobId, Context context) {
        String accept = "application/json, text/json";
        return this.service.cancelHealthJob(this.getEndpoint(), this.getApiVersion(), jobId, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<HealthHeaders, Void>> healthWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, StringIndexType stringIndexType, Boolean loggingOptOut, Context context) {
        String accept = "application/json, text/json";
        return this.service.health(this.getEndpoint(), this.getApiVersion(), modelVersion, stringIndexType, loggingOptOut, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<EntitiesResult>> entitiesRecognitionGeneralWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, StringIndexType stringIndexType, Context context) {
        String accept = "application/json, text/json";
        return this.service.entitiesRecognitionGeneral(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, stringIndexType, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PiiResult>> entitiesRecognitionPiiWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, String domain, StringIndexType stringIndexType, List<PiiCategory> piiCategories, Context context) {
        String accept = "application/json, text/json";
        String piiCategoriesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(piiCategories, CollectionFormat.CSV);
        return this.service.entitiesRecognitionPii(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, domain, stringIndexType, piiCategoriesConverted, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<EntityLinkingResult>> entitiesLinkingWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, StringIndexType stringIndexType, Context context) {
        String accept = "application/json, text/json";
        return this.service.entitiesLinking(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, stringIndexType, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyPhraseResult>> keyPhrasesWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, Context context) {
        String accept = "application/json, text/json";
        return this.service.keyPhrases(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LanguageResult>> languagesWithResponseAsync(LanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, Context context) {
        String accept = "application/json, text/json";
        return this.service.languages(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, input, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SentimentResponse>> sentimentWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats, Boolean loggingOptOut, Boolean opinionMining, StringIndexType stringIndexType, Context context) {
        String accept = "application/json, text/json";
        return this.service.sentiment(this.getEndpoint(), this.getApiVersion(), modelVersion, showStats, loggingOptOut, opinionMining, stringIndexType, input, "application/json, text/json", context);
    }

    @Host(value="{Endpoint}/text/analytics/{ApiVersion}")
    @ServiceInterface(name="TextAnalyticsClient")
    public static interface TextAnalyticsClientService {
        @Post(value="/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeHeaders, Void>> analyze(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @BodyParam(value="application/json") AnalyzeBatchInput var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/analyze/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeJobState>> analyzeStatus(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="jobId") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skip") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/entities/health/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<HealthcareJobState>> healthStatus(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="jobId") UUID var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$skip") Integer var5, @QueryParam(value="showStats") Boolean var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/entities/health/jobs/{jobId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CancelHealthJobHeaders, Void>> cancelHealthJob(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="jobId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/entities/health/jobs")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<HealthHeaders, Void>> health(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="stringIndexType") StringIndexType var4, @QueryParam(value="loggingOptOut") Boolean var5, @BodyParam(value="application/json") MultiLanguageBatchInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/entities/recognition/general")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<EntitiesResult>> entitiesRecognitionGeneral(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @QueryParam(value="stringIndexType") StringIndexType var6, @BodyParam(value="application/json") MultiLanguageBatchInput var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/entities/recognition/pii")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<PiiResult>> entitiesRecognitionPii(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @QueryParam(value="domain") String var6, @QueryParam(value="stringIndexType") StringIndexType var7, @QueryParam(value="piiCategories") String var8, @BodyParam(value="application/json") MultiLanguageBatchInput var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/entities/linking")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<EntityLinkingResult>> entitiesLinking(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @QueryParam(value="stringIndexType") StringIndexType var6, @BodyParam(value="application/json") MultiLanguageBatchInput var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/keyPhrases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KeyPhraseResult>> keyPhrases(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @BodyParam(value="application/json") MultiLanguageBatchInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/languages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<LanguageResult>> languages(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @BodyParam(value="application/json") LanguageBatchInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/sentiment")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SentimentResponse>> sentiment(@HostParam(value="Endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="model-version") String var3, @QueryParam(value="showStats") Boolean var4, @QueryParam(value="loggingOptOut") Boolean var5, @QueryParam(value="opinionMining") Boolean var6, @QueryParam(value="stringIndexType") StringIndexType var7, @BodyParam(value="application/json") MultiLanguageBatchInput var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

