// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The AnalyzeTextEntityLinkingInput model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("EntityLinking")
@Fluent
public final class AnalyzeTextEntityLinkingInput extends AnalyzeTextTask {
    /*
     * The analysisInput property.
     */
    @JsonProperty(value = "analysisInput")
    private MultiLanguageAnalysisInput analysisInput;

    /*
     * Supported parameters for an Entity Linking task.
     */
    @JsonProperty(value = "parameters")
    private EntityLinkingTaskParameters parameters;

    /** Creates an instance of AnalyzeTextEntityLinkingInput class. */
    public AnalyzeTextEntityLinkingInput() {}

    /**
     * Get the analysisInput property: The analysisInput property.
     *
     * @return the analysisInput value.
     */
    public MultiLanguageAnalysisInput getAnalysisInput() {
        return this.analysisInput;
    }

    /**
     * Set the analysisInput property: The analysisInput property.
     *
     * @param analysisInput the analysisInput value to set.
     * @return the AnalyzeTextEntityLinkingInput object itself.
     */
    public AnalyzeTextEntityLinkingInput setAnalysisInput(MultiLanguageAnalysisInput analysisInput) {
        this.analysisInput = analysisInput;
        return this;
    }

    /**
     * Get the parameters property: Supported parameters for an Entity Linking task.
     *
     * @return the parameters value.
     */
    public EntityLinkingTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for an Entity Linking task.
     *
     * @param parameters the parameters value to set.
     * @return the AnalyzeTextEntityLinkingInput object itself.
     */
    public AnalyzeTextEntityLinkingInput setParameters(EntityLinkingTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }
}
