// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

/** The AnalyzeTextLROResult model. */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "kind",
        defaultImpl = AnalyzeTextLROResult.class)
@JsonTypeName("AnalyzeTextLROResult")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "EntityRecognitionLROResults", value = EntityRecognitionLROResult.class),
    @JsonSubTypes.Type(name = "CustomEntityRecognitionLROResults", value = CustomEntityRecognitionLROResult.class),
    @JsonSubTypes.Type(
            name = "CustomSingleLabelClassificationLROResults",
            value = CustomSingleLabelClassificationLROResult.class),
    @JsonSubTypes.Type(
            name = "CustomMultiLabelClassificationLROResults",
            value = CustomMultiLabelClassificationLROResult.class),
    @JsonSubTypes.Type(name = "EntityLinkingLROResults", value = EntityLinkingLROResult.class),
    @JsonSubTypes.Type(name = "PiiEntityRecognitionLROResults", value = PiiEntityRecognitionLROResult.class),
    @JsonSubTypes.Type(name = "ExtractiveSummarizationLROResults", value = ExtractiveSummarizationLROResult.class),
    @JsonSubTypes.Type(name = "HealthcareLROResults", value = HealthcareLROResult.class),
    @JsonSubTypes.Type(name = "SentimentAnalysisLROResults", value = SentimentLROResult.class),
    @JsonSubTypes.Type(name = "KeyPhraseExtractionLROResults", value = KeyPhraseExtractionLROResult.class),
    @JsonSubTypes.Type(name = "AbstractiveSummarizationLROResults", value = AbstractiveSummarizationLROResult.class)
})
@Fluent
public class AnalyzeTextLROResult extends TaskState {
    /*
     * The taskName property.
     */
    @JsonProperty(value = "taskName")
    private String taskName;

    /** Creates an instance of AnalyzeTextLROResult class. */
    public AnalyzeTextLROResult() {}

    /**
     * Get the taskName property: The taskName property.
     *
     * @return the taskName value.
     */
    public String getTaskName() {
        return this.taskName;
    }

    /**
     * Set the taskName property: The taskName property.
     *
     * @param taskName the taskName value to set.
     * @return the AnalyzeTextLROResult object itself.
     */
    public AnalyzeTextLROResult setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AnalyzeTextLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AnalyzeTextLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }
}
