// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Describes the entities certainty and polarity. */
public enum Certainty {
    /** Enum value positive. */
    POSITIVE("positive"),

    /** Enum value positivePossible. */
    POSITIVE_POSSIBLE("positivePossible"),

    /** Enum value neutralPossible. */
    NEUTRAL_POSSIBLE("neutralPossible"),

    /** Enum value negativePossible. */
    NEGATIVE_POSSIBLE("negativePossible"),

    /** Enum value negative. */
    NEGATIVE("negative");

    /** The actual serialized value for a Certainty instance. */
    private final String value;

    Certainty(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Certainty instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed Certainty object, or null if unable to parse.
     */
    @JsonCreator
    public static Certainty fromString(String value) {
        if (value == null) {
            return null;
        }
        Certainty[] items = Certainty.values();
        for (Certainty item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
