// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Parameters object for a text analysis task using custom models. */
@Fluent
public class CustomTaskParameters extends TaskParameters {
    /*
     * This field indicates the project name for the model.
     */
    @JsonProperty(value = "projectName", required = true)
    private String projectName;

    /*
     * This field indicates the deployment name for the model.
     */
    @JsonProperty(value = "deploymentName", required = true)
    private String deploymentName;

    /** Creates an instance of CustomTaskParameters class. */
    public CustomTaskParameters() {}

    /**
     * Get the projectName property: This field indicates the project name for the model.
     *
     * @return the projectName value.
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * Set the projectName property: This field indicates the project name for the model.
     *
     * @param projectName the projectName value to set.
     * @return the CustomTaskParameters object itself.
     */
    public CustomTaskParameters setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    /**
     * Get the deploymentName property: This field indicates the deployment name for the model.
     *
     * @return the deploymentName value.
     */
    public String getDeploymentName() {
        return this.deploymentName;
    }

    /**
     * Set the deploymentName property: This field indicates the deployment name for the model.
     *
     * @param deploymentName the deploymentName value to set.
     * @return the CustomTaskParameters object itself.
     */
    public CustomTaskParameters setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }
}
