// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains details of errors encountered during a job execution. */
@Fluent
public final class DocumentError {
    /*
     * The ID of the input document.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * Error encountered.
     */
    @JsonProperty(value = "error", required = true)
    private Error error;

    /** Creates an instance of DocumentError class. */
    public DocumentError() {}

    /**
     * Get the id property: The ID of the input document.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: The ID of the input document.
     *
     * @param id the id value to set.
     * @return the DocumentError object itself.
     */
    public DocumentError setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the error property: Error encountered.
     *
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * Set the error property: Error encountered.
     *
     * @param error the error value to set.
     * @return the DocumentError object itself.
     */
    public DocumentError setError(Error error) {
        this.error = error;
        return this;
    }
}
