// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The DocumentWarning model. */
@Fluent
public final class DocumentWarning {
    /*
     * Error code.
     */
    @JsonProperty(value = "code", required = true)
    private WarningCodeValue code;

    /*
     * Warning message.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /*
     * A JSON pointer reference indicating the target object.
     */
    @JsonProperty(value = "targetRef")
    private String targetRef;

    /** Creates an instance of DocumentWarning class. */
    public DocumentWarning() {}

    /**
     * Get the code property: Error code.
     *
     * @return the code value.
     */
    public WarningCodeValue getCode() {
        return this.code;
    }

    /**
     * Set the code property: Error code.
     *
     * @param code the code value to set.
     * @return the DocumentWarning object itself.
     */
    public DocumentWarning setCode(WarningCodeValue code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Warning message.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: Warning message.
     *
     * @param message the message value to set.
     * @return the DocumentWarning object itself.
     */
    public DocumentWarning setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the targetRef property: A JSON pointer reference indicating the target object.
     *
     * @return the targetRef value.
     */
    public String getTargetRef() {
        return this.targetRef;
    }

    /**
     * Set the targetRef property: A JSON pointer reference indicating the target object.
     *
     * @param targetRef the targetRef value to set.
     * @return the DocumentWarning object itself.
     */
    public DocumentWarning setTargetRef(String targetRef) {
        this.targetRef = targetRef;
        return this;
    }
}
