// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The HealthcareEntityLink model. */
@Fluent
public final class HealthcareEntityLink {
    /*
     * Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     */
    @JsonProperty(value = "dataSource", required = true)
    private String dataSource;

    /*
     * Entity id in the given source catalog.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /** Creates an instance of HealthcareEntityLink class. */
    public HealthcareEntityLink() {}

    /**
     * Get the dataSource property: Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     *
     * @return the dataSource value.
     */
    public String getDataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     *
     * @param dataSource the dataSource value to set.
     * @return the HealthcareEntityLink object itself.
     */
    public HealthcareEntityLink setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Get the id property: Entity id in the given source catalog.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Entity id in the given source catalog.
     *
     * @param id the id value to set.
     * @return the HealthcareEntityLink object itself.
     */
    public HealthcareEntityLink setId(String id) {
        this.id = id;
        return this;
    }
}
