// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The KeyPhraseResult model. */
@Fluent
public final class KeyPhraseResult extends PreBuiltResult {
    /*
     * Response by document
     */
    @JsonProperty(value = "documents", required = true)
    private List<KeyPhraseResultDocumentsItem> documents;

    /** Creates an instance of KeyPhraseResult class. */
    public KeyPhraseResult() {}

    /**
     * Get the documents property: Response by document.
     *
     * @return the documents value.
     */
    public List<KeyPhraseResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    /**
     * Set the documents property: Response by document.
     *
     * @param documents the documents value to set.
     * @return the KeyPhraseResult object itself.
     */
    public KeyPhraseResult setDocuments(List<KeyPhraseResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }
}
