// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The SentenceTarget model. */
@Fluent
public final class SentenceTarget {
    /*
     * Targeted sentiment in the sentence.
     */
    @JsonProperty(value = "sentiment", required = true)
    private TokenSentimentValue sentiment;

    /*
     * Target sentiment confidence scores for the target in the sentence.
     */
    @JsonProperty(value = "confidenceScores", required = true)
    private TargetConfidenceScoreLabel confidenceScores;

    /*
     * The target offset from the start of the sentence.
     */
    @JsonProperty(value = "offset", required = true)
    private int offset;

    /*
     * The length of the target.
     */
    @JsonProperty(value = "length", required = true)
    private int length;

    /*
     * The target text detected.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * The array of either assessment or target objects which is related to the target.
     */
    @JsonProperty(value = "relations", required = true)
    private List<TargetRelation> relations;

    /** Creates an instance of SentenceTarget class. */
    public SentenceTarget() {}

    /**
     * Get the sentiment property: Targeted sentiment in the sentence.
     *
     * @return the sentiment value.
     */
    public TokenSentimentValue getSentiment() {
        return this.sentiment;
    }

    /**
     * Set the sentiment property: Targeted sentiment in the sentence.
     *
     * @param sentiment the sentiment value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setSentiment(TokenSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    /**
     * Get the confidenceScores property: Target sentiment confidence scores for the target in the sentence.
     *
     * @return the confidenceScores value.
     */
    public TargetConfidenceScoreLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    /**
     * Set the confidenceScores property: Target sentiment confidence scores for the target in the sentence.
     *
     * @param confidenceScores the confidenceScores value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setConfidenceScores(TargetConfidenceScoreLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    /**
     * Get the offset property: The target offset from the start of the sentence.
     *
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: The target offset from the start of the sentence.
     *
     * @param offset the offset value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: The length of the target.
     *
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: The length of the target.
     *
     * @param length the length value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setLength(int length) {
        this.length = length;
        return this;
    }

    /**
     * Get the text property: The target text detected.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The target text detected.
     *
     * @param text the text value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the relations property: The array of either assessment or target objects which is related to the target.
     *
     * @return the relations value.
     */
    public List<TargetRelation> getRelations() {
        return this.relations;
    }

    /**
     * Set the relations property: The array of either assessment or target objects which is related to the target.
     *
     * @param relations the relations value to set.
     * @return the SentenceTarget object itself.
     */
    public SentenceTarget setRelations(List<TargetRelation> relations) {
        this.relations = relations;
        return this;
    }
}
