// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The SentimentTaskResult model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("SentimentAnalysisResults")
@Fluent
public final class SentimentTaskResult extends AnalyzeTextTaskResult {
    /*
     * The results property.
     */
    @JsonProperty(value = "results", required = true)
    private SentimentResponse results;

    /** Creates an instance of SentimentTaskResult class. */
    public SentimentTaskResult() {}

    /**
     * Get the results property: The results property.
     *
     * @return the results value.
     */
    public SentimentResponse getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     *
     * @param results the results value to set.
     * @return the SentimentTaskResult object itself.
     */
    public SentimentTaskResult setResults(SentimentResponse results) {
        this.results = results;
        return this;
    }
}
