// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for StringIndexTypeResponse. */
public final class StringIndexTypeResponse extends ExpandableStringEnum<StringIndexTypeResponse> {
    /** Static value TextElements_v8 for StringIndexTypeResponse. */
    public static final StringIndexTypeResponse TEXT_ELEMENTS_V8 = fromString("TextElements_v8");

    /** Static value UnicodeCodePoint for StringIndexTypeResponse. */
    public static final StringIndexTypeResponse UNICODE_CODE_POINT = fromString("UnicodeCodePoint");

    /** Static value Utf16CodeUnit for StringIndexTypeResponse. */
    public static final StringIndexTypeResponse UTF16CODE_UNIT = fromString("Utf16CodeUnit");

    /**
     * Creates or finds a StringIndexTypeResponse from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding StringIndexTypeResponse.
     */
    @JsonCreator
    public static StringIndexTypeResponse fromString(String name) {
        return fromString(name, StringIndexTypeResponse.class);
    }

    /** @return known StringIndexTypeResponse values. */
    public static Collection<StringIndexTypeResponse> values() {
        return values(StringIndexTypeResponse.class);
    }
}
