// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Supported parameters for the pre-build Abstractive Summarization task. */
@Fluent
public final class AbstractiveSummarizationTaskParameters extends AbstractiveSummarizationTaskParametersBase {
    /*
     * The modelVersion property.
     */
    @JsonProperty(value = "modelVersion")
    private String modelVersion;

    /*
     * The loggingOptOut property.
     */
    @JsonProperty(value = "loggingOptOut")
    private Boolean loggingOptOut;

    /** Creates an instance of AbstractiveSummarizationTaskParameters class. */
    public AbstractiveSummarizationTaskParameters() {}

    /**
     * Get the modelVersion property: The modelVersion property.
     *
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: The modelVersion property.
     *
     * @param modelVersion the modelVersion value to set.
     * @return the AbstractiveSummarizationTaskParameters object itself.
     */
    public AbstractiveSummarizationTaskParameters setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /**
     * Get the loggingOptOut property: The loggingOptOut property.
     *
     * @return the loggingOptOut value.
     */
    public Boolean isLoggingOptOut() {
        return this.loggingOptOut;
    }

    /**
     * Set the loggingOptOut property: The loggingOptOut property.
     *
     * @param loggingOptOut the loggingOptOut value to set.
     * @return the AbstractiveSummarizationTaskParameters object itself.
     */
    public AbstractiveSummarizationTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        this.loggingOptOut = loggingOptOut;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AbstractiveSummarizationTaskParameters setSentenceCount(Integer sentenceCount) {
        super.setSentenceCount(sentenceCount);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AbstractiveSummarizationTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        super.setStringIndexType(stringIndexType);
        return this;
    }
}
