// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An object representing the summarization result of a single document. */
@Fluent
public final class AbstractiveSummaryDocumentResult extends DocumentResult {
    /*
     * A list of abstractive summaries.
     */
    @JsonProperty(value = "summaries", required = true)
    private List<AbstractiveSummary> summaries;

    /** Creates an instance of AbstractiveSummaryDocumentResult class. */
    public AbstractiveSummaryDocumentResult() {}

    /**
     * Get the summaries property: A list of abstractive summaries.
     *
     * @return the summaries value.
     */
    public List<AbstractiveSummary> getSummaries() {
        return this.summaries;
    }

    /**
     * Set the summaries property: A list of abstractive summaries.
     *
     * @param summaries the summaries value to set.
     * @return the AbstractiveSummaryDocumentResult object itself.
     */
    public AbstractiveSummaryDocumentResult setSummaries(List<AbstractiveSummary> summaries) {
        this.summaries = summaries;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AbstractiveSummaryDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AbstractiveSummaryDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AbstractiveSummaryDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
