// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The AnalyzeTextEntityRecognitionInput model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("EntityRecognition")
@Fluent
public final class AnalyzeTextEntityRecognitionInput extends AnalyzeTextTask {
    /*
     * The analysisInput property.
     */
    @JsonProperty(value = "analysisInput")
    private MultiLanguageAnalysisInput analysisInput;

    /*
     * Supported parameters for an Entity Recognition task.
     */
    @JsonProperty(value = "parameters")
    private EntitiesTaskParameters parameters;

    /** Creates an instance of AnalyzeTextEntityRecognitionInput class. */
    public AnalyzeTextEntityRecognitionInput() {}

    /**
     * Get the analysisInput property: The analysisInput property.
     *
     * @return the analysisInput value.
     */
    public MultiLanguageAnalysisInput getAnalysisInput() {
        return this.analysisInput;
    }

    /**
     * Set the analysisInput property: The analysisInput property.
     *
     * @param analysisInput the analysisInput value to set.
     * @return the AnalyzeTextEntityRecognitionInput object itself.
     */
    public AnalyzeTextEntityRecognitionInput setAnalysisInput(MultiLanguageAnalysisInput analysisInput) {
        this.analysisInput = analysisInput;
        return this;
    }

    /**
     * Get the parameters property: Supported parameters for an Entity Recognition task.
     *
     * @return the parameters value.
     */
    public EntitiesTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for an Entity Recognition task.
     *
     * @param parameters the parameters value to set.
     * @return the AnalyzeTextEntityRecognitionInput object itself.
     */
    public AnalyzeTextEntityRecognitionInput setParameters(EntitiesTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }
}
