// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ClassificationResult model. */
@Fluent
public final class ClassificationResult {
    /*
     * Classification type.
     */
    @JsonProperty(value = "category", required = true)
    private String category;

    /*
     * Confidence score between 0 and 1 of the recognized class.
     */
    @JsonProperty(value = "confidenceScore", required = true)
    private double confidenceScore;

    /** Creates an instance of ClassificationResult class. */
    public ClassificationResult() {}

    /**
     * Get the category property: Classification type.
     *
     * @return the category value.
     */
    public String getCategory() {
        return this.category;
    }

    /**
     * Set the category property: Classification type.
     *
     * @param category the category value to set.
     * @return the ClassificationResult object itself.
     */
    public ClassificationResult setCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the confidenceScore property: Confidence score between 0 and 1 of the recognized class.
     *
     * @return the confidenceScore value.
     */
    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Set the confidenceScore property: Confidence score between 0 and 1 of the recognized class.
     *
     * @param confidenceScore the confidenceScore value to set.
     * @return the ClassificationResult object itself.
     */
    public ClassificationResult setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }
}
