// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** Use custom models to classify text into single label taxonomy. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("CustomSingleLabelClassification")
@Fluent
public final class CustomSingleLabelClassificationLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for a Custom Single Classification task.
     */
    @JsonProperty(value = "parameters")
    private CustomSingleLabelClassificationTaskParameters parameters;

    /** Creates an instance of CustomSingleLabelClassificationLROTask class. */
    public CustomSingleLabelClassificationLROTask() {}

    /**
     * Get the parameters property: Supported parameters for a Custom Single Classification task.
     *
     * @return the parameters value.
     */
    public CustomSingleLabelClassificationTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for a Custom Single Classification task.
     *
     * @param parameters the parameters value to set.
     * @return the CustomSingleLabelClassificationLROTask object itself.
     */
    public CustomSingleLabelClassificationLROTask setParameters(
            CustomSingleLabelClassificationTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CustomSingleLabelClassificationLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
