// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** An object representing the task definition for an Entities Recognition task. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("EntityRecognition")
@Fluent
public final class EntitiesLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for an Entity Recognition task.
     */
    @JsonProperty(value = "parameters")
    private EntitiesTaskParameters parameters;

    /** Creates an instance of EntitiesLROTask class. */
    public EntitiesLROTask() {}

    /**
     * Get the parameters property: Supported parameters for an Entity Recognition task.
     *
     * @return the parameters value.
     */
    public EntitiesTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for an Entity Recognition task.
     *
     * @param parameters the parameters value to set.
     * @return the EntitiesLROTask object itself.
     */
    public EntitiesLROTask setParameters(EntitiesTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public EntitiesLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
