// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** An object representing the task definition for an Entity Linking task. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("EntityLinking")
@Fluent
public final class EntityLinkingLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for an Entity Linking task.
     */
    @JsonProperty(value = "parameters")
    private EntityLinkingTaskParameters parameters;

    /** Creates an instance of EntityLinkingLROTask class. */
    public EntityLinkingLROTask() {}

    /**
     * Get the parameters property: Supported parameters for an Entity Linking task.
     *
     * @return the parameters value.
     */
    public EntityLinkingTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for an Entity Linking task.
     *
     * @param parameters the parameters value to set.
     * @return the EntityLinkingLROTask object itself.
     */
    public EntityLinkingLROTask setParameters(EntityLinkingTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public EntityLinkingLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
