// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The ExtractedSummaryDocumentResult model. */
@Fluent
public final class ExtractedSummaryDocumentResult extends DocumentResult {
    /*
     * A ranked list of sentences representing the extracted summary.
     */
    @JsonProperty(value = "sentences", required = true)
    private List<ExtractedSummarySentence> sentences;

    /** Creates an instance of ExtractedSummaryDocumentResult class. */
    public ExtractedSummaryDocumentResult() {}

    /**
     * Get the sentences property: A ranked list of sentences representing the extracted summary.
     *
     * @return the sentences value.
     */
    public List<ExtractedSummarySentence> getSentences() {
        return this.sentences;
    }

    /**
     * Set the sentences property: A ranked list of sentences representing the extracted summary.
     *
     * @param sentences the sentences value to set.
     * @return the ExtractedSummaryDocumentResult object itself.
     */
    public ExtractedSummaryDocumentResult setSentences(List<ExtractedSummarySentence> sentences) {
        this.sentences = sentences;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractedSummaryDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractedSummaryDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractedSummaryDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
