// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

/** The ExtractiveSummarizationLROResult model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("ExtractiveSummarizationLROResults")
@Fluent
public final class ExtractiveSummarizationLROResult extends AnalyzeTextLROResult {
    /*
     * The results property.
     */
    @JsonProperty(value = "results", required = true)
    private ExtractiveSummarizationResult results;

    /** Creates an instance of ExtractiveSummarizationLROResult class. */
    public ExtractiveSummarizationLROResult() {}

    /**
     * Get the results property: The results property.
     *
     * @return the results value.
     */
    public ExtractiveSummarizationResult getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     *
     * @param results the results value to set.
     * @return the ExtractiveSummarizationLROResult object itself.
     */
    public ExtractiveSummarizationLROResult setResults(ExtractiveSummarizationResult results) {
        this.results = results;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractiveSummarizationLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractiveSummarizationLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExtractiveSummarizationLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }
}
